
// +----------------------------------------------------------------------------------------+ //
// |                                            !FT PANEL  \/                              | //
// |                            Knowledge of the ancients ( )                             | //
// |_________________________________________________o0o___(_)___o0o________________________| //
// |_____|_____|_____|_____|_____|_____|_____|_____|_____|_____|_____|_____|_____|____|_____| //
// |                                                                                   2011 | //
// |----------------------------------------------------------------------------------------| //
// | Programming language:     MQL4                                                         | //
// | Development platform:     MetaTrader 4                                                 | //
// |          End product:     Indicator for MetaTrader 4 designed                          | //
// |                           for Build 229 (current version)                              | //
// +----------------------------------------------------------------------------------------+ //

#property indicator_chart_window

color    TextColor2  = C'192,192,192';
color    TextColor3  = C'150,200,250';
color    TextColor4  = C'105,105,105';
color    BoxColor    = C'13,13,63';
color    BoxColor1   = C'40,80,120';
color    BoxColor2   = C'30,50,83';

// ------------------------------------------------------------------------------------------ //
//                            E X T E R N A L   V A R I A B L E S                             //
// ------------------------------------------------------------------------------------------ //

extern bool show.equity.info  = false;
extern bool show.rules        = false;

// ------------------------------------------------------------------------------------------ //
//                            I N T E R N A L   V A R I A B L E S                             //
// ------------------------------------------------------------------------------------------ //

int  WhatWindow     =  0;
int  WhatWindow1     = 1;
int  WhatCorner0     = 0;
int  WhatCorner1     = 1;
int  WhatCorner3     = 3;
int    Shift.up.down   = 0;
int    Shift.sideway   = 0;
bool        show.timer        = true;
bool        show.extra.digit  = false;  
int         BidFontSize    =  30;
string      BidFontType    =  "Arial Bold";
int         FontSize       =  11;
string      FontType       =  "Arial";
string      FontType2       =  "Arial Bold";
double      DecNos;
double      myPoint;
double      SetPoint() 

   { 
   double mPoint; 
   
   if (Digits < 4) 
   mPoint = 0.01; 
   else 
   mPoint = 0.0001; 
   
   return(mPoint); 
   }

// ------------------------------------------------------------------------------------------ //
//                             I N I T I A L I S A T I O N                                    //
// ------------------------------------------------------------------------------------------ //

   int init()
   {
   IndicatorShortName("Price-Info");  
    myPoint = SetPoint(); 
    
   return(0);
   }

// ------------------------------------------------------------------------------------------ //
//                            D E - I N I T I A L I S A T I O N                               //
// ------------------------------------------------------------------------------------------ //

   int deinit()
   {
   ObjectsDeleteAll(WhatWindow,OBJ_LABEL);
   ObjectsDeleteAll(WhatWindow1,OBJ_LABEL);
   deleteObjects();
   return(0);
   }

// ------------------------------------------------------------------------------------------ //
//                                M A I N   P R O C E D U R E                                 //
// ------------------------------------------------------------------------------------------ //

   int start()
   {
   
    if(show.extra.digit){int digit=1;int digitshift=-3;int digitshift1=-5;int digitshift2=3;int fontsize=4;int sprd=1;}
    else{ digitshift=0;digitshift1=0;digitshift2=0;fontsize=0;sprd=0;}

    if (StringFind (Symbol(),"JPY", 0) != -1){ DecNos = 2+digit;}
        else { DecNos = 4+digit; }
     
   int    counted_bars=IndicatorCounted();
        
// ------------------------------------------------------------------------------------------ // 

   CreateFX1_Labels( "BoxFX1-1",4,4); 
   ObjectSetText("BoxFX1-1", "g", 100, "Webdings", BoxColor1);
   
   CreateFX1_Labels( "BoxFX1-2",4,133); 
   ObjectSetText("BoxFX1-2", "g", 100, "Webdings", BoxColor1);

   CreateFX1_Labels( "BoxFX1-3",4,266); 
   ObjectSetText("BoxFX1-3", "g", 100, "Webdings", BoxColor1);
   
   CreateFX1_Labels( "BoxFX1-4",4,372); 
   ObjectSetText("BoxFX1-4", "g", 100, "Webdings", BoxColor1);
   
   CreateFX1_Labels( "BoxFX1-4b",4,492); 
   ObjectSetText("BoxFX1-4b", "g", 100, "Webdings", BoxColor1);
   
   CreateFX1_Labels( "BoxFX1-5",6,6); 
   ObjectSetText("BoxFX1-5", "g", 96, "Webdings", BoxColor2);
   
   CreateFX1_Labels( "BoxFX1-6",6,134); 
   ObjectSetText("BoxFX1-6", "g", 96, "Webdings", BoxColor2);
   
   CreateFX1_Labels( "BoxFX1-7",6,262); 
   ObjectSetText("BoxFX1-7", "g", 96, "Webdings", BoxColor2);
   
   CreateFX1_Labels( "BoxFX1-8",6,376); 
   ObjectSetText("BoxFX1-8", "g", 96, "Webdings", BoxColor2);
   
   CreateFX1_Labels( "BoxFX1-9",6,496); 
   ObjectSetText("BoxFX1-9", "g", 96, "Webdings", BoxColor2);

// ------------------------------------------------------------------------------------------ //

   //Create Headings
   CreateFX1_Labels( "FX1-X1",26,7); 
   ObjectSetText("FX1-X1", "A L P H A", 21, "Impact", White);
   
   CreateFX1_Labels( "FX1-X2",21,34); 
   ObjectSetText("FX1-X2", "T  R  A  D  E  R", 16, "Impact", TextColor3);
   
// ------------------------------------------------------------------------------------------ //   
   
   CreateFX3_Labels( "BoxFX3-1",4,4); 
   ObjectSetText("BoxFX3-1", "g", 100, "Webdings", BoxColor1);
   
   CreateFX3_Labels( "BoxFX3-2",4,133); 
   ObjectSetText("BoxFX3-2", "g", 100, "Webdings", BoxColor1);
   
   CreateFX3_Labels( "BoxFX3-3",4,266); 
   ObjectSetText("BoxFX3-3", "g", 100, "Webdings", BoxColor1);
   
   CreateFX3_Labels( "BoxFX3-4",4,375); 
   ObjectSetText("BoxFX3-4", "g", 100, "Webdings", BoxColor1);
   
   CreateFX3_Labels( "BoxFX3-5",6,6); 
   ObjectSetText("BoxFX3-5", "g", 96, "Webdings", BoxColor2);
   
   CreateFX3_Labels( "BoxFX3-6",6,134); 
   ObjectSetText("BoxFX3-6", "g", 96, "Webdings", BoxColor2);
   
   CreateFX3_Labels( "BoxFX3-7",6,262); 
   ObjectSetText("BoxFX3-7", "g", 96, "Webdings", BoxColor2);
   
   CreateFX3_Labels( "BoxFX3-8",6,380); 
   ObjectSetText("BoxFX3-8", "g", 96, "Webdings", BoxColor2);
   
// ------------------------------------------------------------------------------------------ //      

   double spread = (Ask-Bid)/myPoint;
   
   if(spread>1 && spread<=10)
   
   int sprdshift=4;
   
   ObjectDelete("Obj01");
   ObjectCreate("Obj01", OBJ_LABEL, WhatWindow, 0, 0);
   ObjectSetText("Obj01", "Spread: "+DoubleToStr(spread,1)+" pips", 12, "Arial", Yellow);
   ObjectSet("Obj01", OBJPROP_CORNER, WhatCorner3);
   ObjectSet("Obj01", OBJPROP_BACK, false);
   ObjectSet("Obj01", OBJPROP_XDISTANCE, 9+sprdshift);
   ObjectSet("Obj01", OBJPROP_YDISTANCE, 14); 

// ------------------------------------------------------------------------------------------ //     

   string symbol="";
   
        if (Symbol()=="EURUSD" || Symbol()=="EURUSDm") {symbol="EURUSD";}
   else if (Symbol()=="GBPUSD" || Symbol()=="GBPUSDm") {symbol="GBPUSD";}
   else if (Symbol()=="USDCHF" || Symbol()=="USDCHFm") {symbol="USDCHF";}
   else if (Symbol()=="USDJPY" || Symbol()=="USDJPYm") {symbol="USDJPY";}
   else if (Symbol()=="EURJPY" || Symbol()=="EURJPYm") {symbol="EURJPY";}
   else if (Symbol()=="EURCHF" || Symbol()=="EURCHFm") {symbol="EURCHF";}
   else if (Symbol()=="EURGBP" || Symbol()=="EURGBPm") {symbol="EURGBP";}
   else if (Symbol()=="USDCAD" || Symbol()=="USDCADm") {symbol="USDCAD";}
   else if (Symbol()=="AUDUSD" || Symbol()=="AUDUSDm") {symbol="AUDUSD";}
   else if (Symbol()=="GBPCHF" || Symbol()=="GBPCHFm") {symbol="GBPCHF";}
   else if (Symbol()=="GBPJPY" || Symbol()=="GBPJPYm") {symbol="GBPJPY";}
   else if (Symbol()=="CHFJPY" || Symbol()=="CHFJPYm") {symbol="CHFJPY";}
   else if (Symbol()=="NZDUSD" || Symbol()=="NZDUSDm") {symbol="NZDUSD";}
   else if (Symbol()=="EURCAD" || Symbol()=="EURCADm") {symbol="EURCAD";}
   else if (Symbol()=="AUDJPY" || Symbol()=="AUDJPYm") {symbol="AUDJPY";}
   else if (Symbol()=="EURAUD" || Symbol()=="EURAUDm") {symbol="EURAUD";}
   else if (Symbol()=="AUDCAD" || Symbol()=="AUDCADm") {symbol="AUDCAD";}
   else if (Symbol()=="AUDNZD" || Symbol()=="AUDNZDm") {symbol="AUDNZD";}
   else if (Symbol()=="NZDJPY" || Symbol()=="NZDJPYm") {symbol="NZDJPY";}
   else if (Symbol()=="CADJPY" || Symbol()=="CADJPYm") {symbol="CADJPY";}
   else if (Symbol()=="XAUUSD" || Symbol()=="XAUUSDm") {symbol="XAUUSD";}
   else if (Symbol()=="XAGUSD" || Symbol()=="XAGUSDm") {symbol="XAGUSD";}
   else if (Symbol()=="GBPAUD" || Symbol()=="GBPAUDm") {symbol="GBPAUD";}
   else if (Symbol()=="GBPCAD" || Symbol()=="GBPCADm") {symbol="GBPCAD";}
   else if (Symbol()=="AUFCHF" || Symbol()=="AUFCHFm") {symbol="AUFCHF";}
   else if (Symbol()=="CADCHF" || Symbol()=="CADCHFm") {symbol="CADCHF";}
   else if (Symbol()=="NZDCHF" || Symbol()=="NZDCHFm") {symbol="NZDCHF";}
   else if (Symbol()=="GBPNZD" || Symbol()=="GBPNZDm") {symbol="GBPNZD";}
   else if (Symbol()=="AUDCHF" || Symbol()=="AUDCHFm") {symbol="AUDCHF";}
   else if (Symbol()=="EURNZD" || Symbol()=="EURNZDm") {symbol="EURNZD";}
   else{symbol=Symbol();int syblsize = 5;int syblshift=2;}
        
   ObjectDelete("Obj02");
   ObjectCreate("Obj02", OBJ_LABEL, WhatWindow, 0, 0);
   ObjectSetText("Obj02",symbol , 22-syblsize, BidFontType, TextColor3);
   ObjectSet("Obj02", OBJPROP_CORNER, WhatCorner3);
   ObjectSet("Obj02", OBJPROP_BACK, false);
   ObjectSet("Obj02", OBJPROP_XDISTANCE, 9-syblshift);
   ObjectSet("Obj02", OBJPROP_YDISTANCE, 30); 
     
// ------------------------------------------------------------------------------------------ //

   ObjectDelete("Obj03");
   ObjectCreate("Obj03", OBJ_LABEL, WhatWindow, 0, 0);
   ObjectSetText("Obj03", "High:"+DoubleToStr(iHigh(NULL, PERIOD_D1, 0),DecNos), 14, FontType, SlateGray);
   ObjectSet("Obj03", OBJPROP_CORNER, WhatCorner3);
   ObjectSet("Obj03", OBJPROP_BACK, false);
   ObjectSet("Obj03", OBJPROP_XDISTANCE, 20+digitshift);
   ObjectSet("Obj03", OBJPROP_YDISTANCE, 118);  
        

   ObjectCreate("Obj04", OBJ_LABEL, WhatWindow, 0, 0);
   ObjectSetText("Obj04", DoubleToStr(Bid, DecNos), BidFontSize-fontsize, BidFontType, White);
   ObjectSet("Obj04", OBJPROP_CORNER, WhatCorner3);
   ObjectSet("Obj04", OBJPROP_XDISTANCE, 10+digitshift1);
   ObjectSet("Obj04", OBJPROP_YDISTANCE, 76+digitshift2);
           

   ObjectDelete("Obj05");
   ObjectCreate("Obj05", OBJ_LABEL, WhatWindow, 0, 0);
   ObjectSetText("Obj05", "Low:"+DoubleToStr(iLow(NULL, PERIOD_D1, 0), DecNos), 14, FontType, SlateGray);
   ObjectSet("Obj05", OBJPROP_CORNER, WhatCorner3);
   ObjectSet("Obj05", OBJPROP_BACK, false);
   ObjectSet("Obj05", OBJPROP_XDISTANCE, 21+digitshift);
   ObjectSet("Obj05", OBJPROP_YDISTANCE, 62);

// ------------------------------------------------------------------------------------------ //

   if(show.equity.info == True)
   { 
   
   ObjectDelete("Obj.inf.02");
   ObjectCreate("Obj.inf.02", OBJ_LABEL, WhatWindow, 0, 0);
   ObjectSetText("Obj.inf.02", "Fund: "+DoubleToStr(AccountBalance(),2) , FontSize, FontType2, TextColor3);
   ObjectSet("Obj.inf.02", OBJPROP_CORNER, WhatCorner1);
   ObjectSet("Obj.inf.02", OBJPROP_BACK, false);
   ObjectSet("Obj.inf.02", OBJPROP_XDISTANCE, 20);
   ObjectSet("Obj.inf.02", OBJPROP_YDISTANCE, 160);
   

/*   ObjectDelete("Obj.inf.03");
   ObjectCreate("Obj.inf.03", OBJ_LABEL, WhatWindow, 0, 0);
   ObjectSetText("Obj.inf.03", "Equity : "+DoubleToStr(AccountEquity(),2) , FontSize, FontType, TextColor4);
   ObjectSet("Obj.inf.03", OBJPROP_CORNER, WhatCorner1);
   ObjectSet("Obj.inf.03", OBJPROP_BACK, false);
   ObjectSet("Obj.inf.03", OBJPROP_XDISTANCE, 20);
   ObjectSet("Obj.inf.03", OBJPROP_YDISTANCE, 217); 
   

   ObjectDelete("Obj.inf.05");
   ObjectCreate("Obj.inf.05", OBJ_LABEL, WhatWindow, 0, 0);
   ObjectSetText("Obj.inf.05", "Margin : "+DoubleToStr(AccountMargin(),2) , FontSize, FontType, TextColor4);
   ObjectSet("Obj.inf.05", OBJPROP_CORNER, WhatCorner1);
   ObjectSet("Obj.inf.05", OBJPROP_BACK, false);
   ObjectSet("Obj.inf.05", OBJPROP_XDISTANCE, 20);
   ObjectSet("Obj.inf.05", OBJPROP_YDISTANCE, 202);
   

   ObjectDelete("Obj.inf.06");
   ObjectCreate("Obj.inf.06", OBJ_LABEL, WhatWindow, 0, 0);
   ObjectSetText("Obj.inf.06", "Free : "+DoubleToStr(AccountFreeMargin(),2) , FontSize, FontType, TextColor4);
   ObjectSet("Obj.inf.06", OBJPROP_CORNER, WhatCorner1);
   ObjectSet("Obj.inf.06", OBJPROP_BACK, false);
   ObjectSet("Obj.inf.06", OBJPROP_XDISTANCE, 20);
   ObjectSet("Obj.inf.06", OBJPROP_YDISTANCE, 187); */
   

   ObjectDelete("Obj.inf.07");
   ObjectCreate("Obj.inf.07", OBJ_LABEL, WhatWindow, 0, 0);
   ObjectSetText("Obj.inf.07", "Profit : "+DoubleToStr(AccountProfit(),2) , FontSize, FontType2, TextColor3);
   ObjectSet("Obj.inf.07", OBJPROP_CORNER, WhatCorner1);
   ObjectSet("Obj.inf.07", OBJPROP_BACK, false);
   ObjectSet("Obj.inf.07", OBJPROP_XDISTANCE, 20);
   ObjectSet("Obj.inf.07", OBJPROP_YDISTANCE, 145); 
   
      
   }//end of equity
   
   if(show.rules == True)
   { 
   
   ObjectDelete("Obj.rule.0");
   ObjectCreate("Obj.rule.0", OBJ_LABEL, WhatWindow1, 0, 0);
   ObjectSetText("Obj.rule.0", "RULES FOR ENTRY & EXIT " , FontSize, FontType2, Crimson);
   ObjectSet("Obj.rule.0", OBJPROP_CORNER, WhatCorner1);
   ObjectSet("Obj.rule.0", OBJPROP_BACK, false);
   ObjectSet("Obj.rule.0", OBJPROP_XDISTANCE, 63);
   ObjectSet("Obj.rule.0", OBJPROP_YDISTANCE, 20);
   
   ObjectDelete("Obj.rule.01");
   ObjectCreate("Obj.rule.01", OBJ_LABEL, WhatWindow1, 0, 0);
   ObjectSetText("Obj.rule.01", "ENTRY: " , FontSize, FontType2, TextColor3);
   ObjectSet("Obj.rule.01", OBJPROP_CORNER, WhatCorner1);
   ObjectSet("Obj.rule.01", OBJPROP_BACK, false);
   ObjectSet("Obj.rule.01", OBJPROP_XDISTANCE, 190);
   ObjectSet("Obj.rule.01", OBJPROP_YDISTANCE, 40);
   
   ObjectDelete("Obj.rule.02");
   ObjectCreate("Obj.rule.02", OBJ_LABEL, WhatWindow1, 0, 0);
   ObjectSetText("Obj.rule.02", "Change of TREND Histogram " , FontSize, FontType2, TextColor3);
   ObjectSet("Obj.rule.02", OBJPROP_CORNER, WhatCorner1);
   ObjectSet("Obj.rule.02", OBJPROP_BACK, false);
   ObjectSet("Obj.rule.02", OBJPROP_XDISTANCE, 42);
   ObjectSet("Obj.rule.02", OBJPROP_YDISTANCE, 55);
           
/*   ObjectDelete("Obj.rule.03");
   ObjectCreate("Obj.rule.03", OBJ_LABEL, WhatWindow1, 0, 0);
   ObjectSetText("Obj.rule.03", "with Trend 1 & 2 Confirming " , FontSize, FontType2, TextColor3);
   ObjectSet("Obj.rule.03", OBJPROP_CORNER, WhatCorner1);
   ObjectSet("Obj.rule.03", OBJPROP_BACK, false);
   ObjectSet("Obj.rule.03", OBJPROP_XDISTANCE, 47);
   ObjectSet("Obj.rule.03", OBJPROP_YDISTANCE, 70);   */
   
   ObjectDelete("Obj.rule.04");
   ObjectCreate("Obj.rule.04", OBJ_LABEL, WhatWindow1, 0, 0);
   ObjectSetText("Obj.rule.04", "EXIT: " , FontSize, FontType2, TextColor3);
   ObjectSet("Obj.rule.04", OBJPROP_CORNER, WhatCorner1);
   ObjectSet("Obj.rule.04", OBJPROP_BACK, false);
   ObjectSet("Obj.rule.04", OBJPROP_XDISTANCE, 205);
   ObjectSet("Obj.rule.04", OBJPROP_YDISTANCE, 100); 
   
   ObjectDelete("Obj.rule.05");
   ObjectCreate("Obj.rule.05", OBJ_LABEL, WhatWindow1, 0, 0);
   ObjectSetText("Obj.rule.05", "When TREND Lines Cross " , FontSize, FontType2, TextColor3);
   ObjectSet("Obj.rule.05", OBJPROP_CORNER, WhatCorner1);
   ObjectSet("Obj.rule.05", OBJPROP_BACK, false);
   ObjectSet("Obj.rule.05", OBJPROP_XDISTANCE, 60);
   ObjectSet("Obj.rule.05", OBJPROP_YDISTANCE, 115);
      
   }//end of show rules    
// ------------------------------------------------------------------------------------------ //

   if (show.timer == True)
   {
   int Bar.Hour = Time[0] + 60 * Period() - TimeCurrent();
   double ld_0 = Bar.Hour / 60.0;
   int Bar.Sec = Bar.Hour % 60;
   Bar.Hour = (Bar.Hour - Bar.Hour % 60) / 60;
   
   if(Bar.Sec<=9)string zero="0";
   if(Bar.Hour>=1 && Bar.Hour<=9)int shift=-10;
   else if(Bar.Hour>=10 && Bar.Hour<=99)shift=-13;
   else if(Bar.Hour>=100 && Bar.Hour<=999)shift=-16;
   else if(Bar.Hour>=1000 && Bar.Hour<=9999)shift=-24;
   else if(Bar.Hour>=10000 && Bar.Hour<=99999)shift=-29;
   

   ObjectDelete("Obj06");
   ObjectCreate("Obj06", OBJ_LABEL, WhatWindow, 0, 0);
   ObjectSetText("Obj06", "Bar Time Left", 12, "Arial Bold", SlateGray);
   ObjectSet("Obj06", OBJPROP_CORNER, WhatCorner3);
   ObjectSet("Obj06", OBJPROP_BACK, false);
   ObjectSet("Obj06", OBJPROP_XDISTANCE, 20);
   ObjectSet("Obj06", OBJPROP_YDISTANCE, 162);
   
   ObjectDelete("Obj06b");
   ObjectCreate("Obj06b", OBJ_LABEL, WhatWindow, 0, 0);
   ObjectSetText("Obj06b", Bar.Hour + ":"+zero+"" + Bar.Sec, 12, "Arial Bold", White);
   ObjectSet("Obj06b", OBJPROP_CORNER, WhatCorner3);
   ObjectSet("Obj06b", OBJPROP_BACK, false);
   ObjectSet("Obj06b", OBJPROP_XDISTANCE, 55+shift);
   ObjectSet("Obj06b", OBJPROP_YDISTANCE, 142);
   
   }//end of show.timer
      
// ------------------------------------------------------------------------------------------ //
  
   }
   return(0);  

   int CreateFX1_Labels( string b, int x, int y ) {
   ObjectCreate( b, OBJ_LABEL, WhatWindow, 0, 0 );
   ObjectSet( b, OBJPROP_CORNER, WhatCorner1 );
   ObjectSet( b, OBJPROP_XDISTANCE,x+Shift.up.down);
   ObjectSet( b, OBJPROP_YDISTANCE,y+Shift.sideway);
   ObjectSet( b, OBJPROP_BACK, false );
   }
   
   int CreateFX3_Labels( string c, int x, int y ) {
   ObjectCreate( c, OBJ_LABEL, WhatWindow, 0, 0 );
   ObjectSet( c, OBJPROP_CORNER, WhatCorner3 );
   ObjectSet( c, OBJPROP_XDISTANCE,x+Shift.up.down);
   ObjectSet( c, OBJPROP_YDISTANCE,y+Shift.sideway);
   ObjectSet( c, OBJPROP_BACK, false );
   }
  
   void deleteObjects(){
   
    ObjectDelete("BoxFX1-1"); ObjectDelete("BoxFX3-1");
    ObjectDelete("BoxFX1-2"); ObjectDelete("BoxFX3-2");
    ObjectDelete("BoxFX1-3"); ObjectDelete("BoxFX3-3");
    ObjectDelete("BoxFX1-4"); ObjectDelete("BoxFX3-4");
    ObjectDelete("BoxFX1-5"); ObjectDelete("BoxFX3-5");
    ObjectDelete("BoxFX1-6"); ObjectDelete("BoxFX3-6");
    ObjectDelete("BoxFX1-7"); ObjectDelete("BoxFX3-7");
    ObjectDelete("BoxFX1-8"); ObjectDelete("BoxFX3-8");
    ObjectDelete("FX1-XARD");
    
    }

// END OF CODE                \/
// Knowledge of the ancients ( )
//______________________o0o___(_)___o0o_____
//_______________________________2011_

